% bfor_init_vars_equiliriums_fipit.m
% 
% setup file for the example Mendoza-Villalvazo model with endogenous regime-switching
% 
% Estimating Macroeconomic Models of Financial Crises: An Endogenous Regime-Switching Approach*
%   Gianluca Benigno, Andrew Foerster, Christopher Otrok, Alessandro Rebucci
% 
% Updated July 2024
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
function [f, Pmat, vars, THETA, steady] = bfor_init_vars_equilibriums_fipit()

% -- Non-predetermined variables -- %
syms cp_  lp_  vp_  qp_  wp_  mup_  lambdap_  bstarp_  dp_  rp_  gdpp_  invp_  wcp_  nxratiop_  levp_  bratiop_  'real';       % declare variables at t+1
syms c_   l_   v_   q_   w_   mu_   lambda_   bstar_   d_   r_   gdp_   inv_   wc_   nxratio_   lev_   bratio_   'real';       % declare variables at t
syms css_ lss_ vss_ qss_ wss_ muss_ lambdass_ bstarss_ dss_ rss_ gdpss_ invss_ wcss_ nxratioss_ levss_ bratioss_ 'real';       % declare variables at steady state
vars.yvarsp = [cp_  lp_  vp_  qp_  wp_  mup_  lambdap_  bstarp_  dp_  rp_  gdpp_  invp_  wcp_  nxratiop_  levp_  bratiop_ ]';  % vector for t+1 
vars.yvars  = [c_   l_   v_   q_   w_   mu_   lambda_   bstar_   d_   r_   gdp_   inv_   wc_   nxratio_   lev_   bratio_  ]';  % vector for t
vars.yvarss	= [css_ lss_ vss_ qss_ wss_ muss_ lambdass_ bstarss_ dss_ rss_ gdpss_ invss_ wcss_ nxratioss_ levss_ bratioss_]';  % vector for steady state

% -- Predetermined Variables -- %
syms k_    b_    a_    p_    rstar_    'real';      % declare variables at t
syms klag_ blag_ alag_ plag_ rstarlag_ 'real';      % declare variables at t-1
syms kss_  bss_  ass_  pss_  rstarss_  'real';      % declare variables at steady state
vars.xvars  = [k_    b_    a_    p_    rstar_   ]'; % vector for t
vars.xlag   = [klag_ blag_ alag_ plag_ rstarlag_]'; % vector for t-1
vars.xvarss = [kss_  bss_  ass_  pss_  rstarss_ ]'; % vector for steady state     

% -- Shocks -- %
syms epsilonap_ epsilonpp_ epsilonrp_ 'real';   % declare shocks at t+1
syms epsilona_  epsilonp_  epsilonr_  'real';   % declare shocks at t
vars.epsp = [epsilonap_ epsilonpp_ epsilonrp_]';% vector for t+1 
vars.eps  = [epsilona_  epsilonp_  epsilonr_ ]';% vector for t


% -- Switching Parameters -- %
syms varphi_sp nu_sp 'real';                % declare parameters at t+1
syms varphi_s  nu_s  'real';                % declare parameters at t
syms varphibar 'real';                      % declare steady state
vars.t1varsp    = varphi_sp;                % vector of perturbed at t+1
vars.t1vars     = varphi_s;                 % vector of perturbed at t
vars.t1varss    = varphibar;                % vector of perturbed steady state
vars.t2varsp    = nu_sp;                    % vector of non-perturbed at t+1
vars.t2vars     = nu_s;                     % vector of non-perturbed at t

% Collecting Parameters
vars.tvarsp     = [varphi_sp nu_sp]';       % vector of parameters at t+1
vars.tvars      = [varphi_s  nu_s ]';       % vector of parameters at t

% -- Parameters -- %
syms oomega ssigma ttau astar aalpha ggamma eeta pphi ddelta bbeta kkappa...
        iiota rrhor rrhop rrhoa rbar pbar abar ssigmar ssigmap ssigmaa...
        ssigmaar ggamma00 ggamma01 ggamma10 ggamma11 varphi_1 varphi_2 nu_1 nu_2 'real';
THETA = [oomega ssigma astar ttau aalpha ggamma eeta pphi ddelta bbeta ...
    kkappa iiota rrhor rrhop rrhoa rbar pbar abar ssigmar ssigmap ssigmaa ...
    ssigmaar ggamma00 ggamma01 ggamma10 ggamma11 varphi_1 varphi_2 nu_1 nu_2]';

% -- Transition Matrix -- %
% syms Pmat;
Pmat = [1-exp(ggamma00-ggamma01*bstar_)/(1+exp(ggamma00-ggamma01*bstar_))       exp(ggamma00-ggamma01*bstar_)/(1+exp(ggamma00-ggamma01*bstar_)); ...
          exp(ggamma10-ggamma11*mu_)/(1+exp(ggamma10-ggamma11*mu_))           1-exp(ggamma10-ggamma11*mu_)/(1+exp(ggamma10-ggamma11*mu_))];

% -- Equilibrium Conditions -- %
f = sym('ff',[21 1]);
f(1)  = (exp(c_)-exp(l_)^oomega/oomega)^(-ssigma) - exp(lambda_)*(1+ttau);
f(2)  = aalpha*exp(a_)*astar*exp(klag_)^ggamma*exp(l_)^(aalpha-1)*exp(v_)^eeta - exp(w_)*(1+pphi*(exp(r_)-1) + mu_*pphi*exp(r_)/exp(lambda_));
f(3)  = eeta*exp(a_)*astar*exp(klag_)^ggamma*exp(l_)^aalpha*exp(v_)^(eeta-1) - exp(p_)*(1+pphi*(exp(r_)-1) + mu_*pphi*exp(r_)/exp(lambda_));
f(4)  = mu_ + bbeta*exp(r_)*exp(lambdap_)- exp(lambda_);
f(5)  = exp(lambda_) - bbeta*exp(lambdap_)/exp(q_)*(exp(dp_) + exp(qp_)) - mu_*kkappa;
f(6)  = ggamma*exp(a_)*astar*exp(klag_)^(ggamma-1)*exp(l_)^aalpha*exp(v_)^eeta - ddelta + iiota/2*((exp(k_) - exp(klag_))/exp(klag_))^2 - exp(d_);
f(7)  = 1 + iiota*((exp(k_) - exp(klag_))/exp(klag_)) - exp(q_);
f(8)  = exp(l_)^(oomega-1)*(1 + ttau) - exp(w_);
f(9)  = exp(a_)*astar*exp(klag_)^ggamma*exp(l_)^aalpha*exp(v_)^eeta - exp(p_)*exp(v_) - pphi*(exp(r_) - 1)*(exp(w_)*exp(l_) + exp(p_)*exp(v_)) - b_/exp(r_) + blag_ - exp(c_)*(1 + ttau) - exp(k_) + (1 - ddelta)*exp(klag_) + iiota/2*(exp(k_) - exp(klag_))^2/exp(klag_);
f(10) = 1/exp(r_)*b_ - pphi* exp(r_)*(exp(w_)*exp(l_) + exp(p_)*exp(v_)) + kkappa*exp(q_)*exp(k_) - bstar_;
f(11) = varphi_s* bstarss_ + nu_s*(bstar_ - bstarss_) - (1 - varphi_s)*muss_ - (1 - nu_s)*(mu_ - muss_);
f(12) = (1 - rrhor)*rbar + rrhor* exp(rstarlag_) + ssigmar*epsilonr_ + ssigmaar*epsilona_ - exp(rstar_);
f(13) = (1 - rrhop)*pbar + rrhop* exp(plag_) + ssigmap*epsilonp_ - exp(p_);
f(14) = (1 - rrhoa)*abar + rrhoa* exp(alag_) + ssigmaa*epsilona_ + ssigmaar*epsilonr_ - exp(a_);
f(15) = exp(r_) - exp(rstar_);
f(16) = exp(k_) - (1 - ddelta)*exp(klag_) - iiota/2*(exp(k_) - exp(klag_))^2/exp(klag_) - exp(inv_);
f(17) = exp(a_)*astar*exp(klag_)^ggamma*exp(l_)^aalpha*exp(v_)^eeta - exp(p_)*exp(v_) - exp(gdp_);
f(18) = pphi*(exp(w_)*exp(l_) + exp(p_)*exp(v_)) - exp(wc_);
f(19) = (1/exp(r_)*b_ - blag_ - pphi* (exp(r_)-1)*(exp(w_)*exp(l_) + exp(p_)*exp(v_)))/exp(gdp_) - nxratio_;
f(20) = (1/exp(r_)*b_ - pphi* exp(r_)*(exp(w_)*exp(l_) + exp(p_)*exp(v_)))/(exp(q_)*exp(k_)) - lev_;
f(21) = blag_/exp(gdp_) - bratio_;

% -- Steady State -- %
bss = -75.5296036545692;
qss = 1;
pss = pbar;
ass = abar;
rss = rbar;
dss = (1 - (1 - rss*bbeta)*kkappa)/bbeta - 1;
Omegal = (  1 + pphi*(rss - 1) + (1 - bbeta*rss)*pphi*rss)/aalpha;
Omegav = (  1 + pphi*(rss - 1) + (1 - bbeta*rss)*pphi*rss)/eeta;
Omegak = (dss + ddelta)/ggamma;
lss = (astar/(Omegak^ggamma*(pss*Omegav)^eeta*((1 + ttau)*Omegal)^(1 - ggamma - eeta)))^(  1/(aalpha*(oomega - 1)));
wss = (1 + ttau)*lss^(oomega - 1);
vss = Omegal/Omegav*(wss*lss)/pss;
kss = Omegav/Omegak*pss*vss;
css = (astar*kss^ggamma*lss^aalpha*vss^eeta -    pss*vss - pphi*(rss - 1)*(wss*lss + pss*vss) - bss/rss +    bss - ddelta*kss)/(1 + ttau);
lambdass = (css - lss^oomega/oomega)^-ssigma/(1 + ttau);
muss = lambdass*(1 - rss*bbeta);
bstarss = bss/rss - pphi*rss*(wss*lss + pss*vss) + kkappa*kss;
rstarss = rss;
gdpss = astar*kss^ggamma*lss^aalpha*vss^eeta - pss*vss;
invss = ddelta*kss;
wcss = pphi*(wss*lss + pss*vss);
nxratioss = (bss/rss - bss - pphi*(rss-1)*(wss*lss + pss*vss))/gdpss;
levss = (bss/rss - pphi*rss*(wss*lss + pss*vss))/(qss*kss);
bratioss = bss/gdpss;

steady.xss = [log(kss); bss; log(ass); log(pss); log(rss)];
steady.yss = [log(css); log(lss); log(vss); log(qss); log(wss); muss; log(lambdass); bstarss; log(dss); log(rstarss); log(gdpss); log(invss); log(wcss); nxratioss; levss; bratioss];
